<?php
// Garante que o VC esteja carregado
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function agt_box_info_shortcode( $atts ) {
    $atts = shortcode_atts( array(
        'texto_antes'        => '',
        'tag_texto_antes'    => 'span',
        'classe_texto_antes' => '',

        'numero'             => '',
        'tag_numero'         => 'h2',
        'classe_numero'      => '',

        'sufixo_numero'      => '',

        'texto_depois'       => '',
        'tag_texto_depois'   => 'span',
        'classe_texto_depois'=> '',

        'descricao'          => '',
        'tag_descricao'      => 'p',
        'classe_descricao'   => '',
    ), $atts );

    ob_start();
    ?>

    <!-- <div class="agt-info-box <?php echo esc_attr($atts['el_class']); ?>" style="padding:20px; border:1px solid #ccc; border-radius:8px; text-align:center;"> -->
    <div class="agt-info-box <?php echo esc_attr($atts['el_class']); ?>" style="">
        <<?php echo esc_attr($atts['tag_texto_antes']); ?> class="before-text <?php echo esc_attr($atts['classe_texto_antes']); ?>">
            <?php echo wp_kses_post($atts['texto_antes']); ?>
        </<?php echo esc_attr($atts['tag_texto_antes']); ?>>

        <<?php echo esc_attr($atts['tag_numero']); ?> class="number <?php echo esc_attr($atts['classe_numero']); ?>">
            <span class="valor"><?php echo wp_kses_post($atts['numero']); ?></span><span class="sufixo"><?php echo wp_kses_post($atts['sufixo_numero']); ?></span>
        </<?php echo esc_attr($atts['tag_numero']); ?>>

        <<?php echo esc_attr($atts['tag_texto_depois']); ?> class="after-text <?php echo esc_attr($atts['classe_texto_depois']); ?>">
            <?php echo wp_kses_post($atts['texto_depois']); ?>
        </<?php echo esc_attr($atts['tag_texto_depois']); ?>>

        <<?php echo esc_attr($atts['tag_descricao']); ?> class="desc <?php echo esc_attr($atts['classe_descricao']); ?>">
            <?php echo wp_kses_post($atts['descricao']); ?>
        </<?php echo esc_attr($atts['tag_descricao']); ?>>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode( 'agt_info_box', 'agt_box_info_shortcode' );

function agt_register_info_box_vc() {
    if ( function_exists( 'vc_map' ) ) {
        vc_map( array(
            'name' => __( 'Box de Informações - AGT', 'agt' ),
            'base' => 'agt_info_box',
            'description' => 'Exibe um box com número e descrição',
            'category' => 'AGT Personalizados',
            'icon' => 'dashicons-info-outline',
            'params' => array(

                // Texto antes
                array(
                    'type' => 'textarea',
                    'heading' => 'Texto antes',
                    'param_name' => 'texto_antes',
                    'description' => 'Aceita tags como <br>, <span>, etc.',
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => 'Tag do Texto antes',
                    'param_name' => 'tag_texto_antes',
                    'value' => array('span', 'p', 'div', 'strong'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => 'Classe do Texto antes',
                    'param_name' => 'classe_texto_antes',
                ),

                // Número
                array(
                    'type' => 'textfield',
                    'heading' => 'Número',
                    'param_name' => 'numero',
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => 'Tag do Número',
                    'param_name' => 'tag_numero',
                    'value' => array('h1','h2','h3','h4','h5','h6','div','span'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => 'Classe do Número',
                    'param_name' => 'classe_numero',
                ),

                // Sufifxo do Número
                array(
                    'type' => 'textfield',
                    'heading' => 'Sufixo do Número',
                    'param_name' => 'sufixo_numero',
                ),

                // Texto depois
                array(
                    'type' => 'textfield',
                    'heading' => 'Texto depois',
                    'param_name' => 'texto_depois',
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => 'Tag do Texto depois',
                    'param_name' => 'tag_texto_depois',
                    'value' => array('span', 'p', 'div', 'strong'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => 'Classe do Texto depois',
                    'param_name' => 'classe_texto_depois',
                ),

                // Descrição
                array(
                    'type' => 'textarea',
                    'heading' => 'Descrição',
                    'param_name' => 'descricao',
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => 'Tag da Descrição',
                    'param_name' => 'tag_descricao',
                    'value' => array('p', 'div', 'small'),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => 'Classe da Descrição',
                    'param_name' => 'classe_descricao',
                ),

                // Classe geral do widget
                array(
                    'type' => 'textfield',
                    'heading' => __( 'Classe extra CSS', 'agt' ),
                    'param_name' => 'el_class',
                    'description' => __( 'Adicione uma classe CSS personalizada para este elemento.', 'agt' ),
                )
            )
        ) );
    }
}
add_action( 'vc_before_init', 'agt_register_info_box_vc' );
