<?php
// Garante que o VC esteja carregado
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// 1. Shortcode que renderiza o conteúdo
function agt_box_com_borda_shortcode( $atts, $content = null ) {
    $atts = shortcode_atts( array(
        'titulo'   => '',
        'el_class' => '',
    ), $atts );

    ob_start();
    ?>
    <div class="agt-box-com-borda <?php echo esc_attr($atts['el_class']); ?>">
        <?php if ( ! empty($atts['titulo']) ) : ?>
            <h3 class="title"><?php echo esc_html($atts['titulo']); ?></h3>
        <?php endif; ?>

        <div class="content">
            <?php echo wp_kses_post($content); ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode( 'agt_box_com_borda', 'agt_box_com_borda_shortcode' );

// 2. Registro do elemento no Visual Composer
function agt_register_box_com_borda_vc() {
    vc_map( array(
        'name' => __( 'Box com Borda', 'agt' ),
        'base' => 'agt_box_com_borda',
        'description' => 'Box simples com título, conteúdo e borda',
        'category' => 'AGT Personalizados',
        'icon' => 'dashicons-editor-table',
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => 'Título',
                'param_name' => 'titulo',
            ),
            array(
                'type' => 'textarea_html',
                'heading' => 'Conteúdo',
                'param_name' => 'content',
            ),
            array(
                'type' => 'textfield',
                'heading' => __( 'Classe extra CSS', 'agt' ),
                'param_name' => 'el_class',
                'description' => __( 'Adicione uma classe CSS personalizada para este elemento.', 'agt' ),
            ),
        )
    ) );
}
add_action( 'vc_before_init', 'agt_register_box_com_borda_vc' );
