<!doctype html>
<html lang="pt-br">

<head>
	<!-- META -->
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<meta charset="utf-8" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

	<title><?php echo wp_title(); ?></title>

	<!-- Favicon -->
	<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/images/favicon.png" />

	<!-- BOOTSTRAP e CSS -->
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
	<link type="text/css" rel="stylesheet" href="<?php echo get_template_directory_uri() ?>/style.css?v=1.35">

	<!-- FONTS -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300..800;1,300..800&family=Source+Sans+3:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

	<!--JQUERY-->
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

	<!-- SWIPER JS -->
	<link rel="stylesheet" href="https://unpkg.com/swiper@7/swiper-bundle.min.css" />
	<script src="https://unpkg.com/swiper@7/swiper-bundle.min.js"></script>

	<!--JS-->
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>

	<!-- jQuery Mask -->
	<script src="<?php echo get_template_directory_uri(); ?>/libs/jquery.mask.min.js"></script>

	<?php wp_head() ?>

	<!-- Google tag (gtag.js) -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=G-WN1FHC8FKY"></script>
	<script>
	window.dataLayer = window.dataLayer || [];
	function gtag(){dataLayer.push(arguments);}
	gtag('js', new Date());

	gtag('config', 'G-WN1FHC8FKY');
	</script>

</head>

<body <?php body_class(); ?>>

	<div class="main-wrapper">

		<?php
		// Definicao de strings de acordo com idioma
		//en-US | pt-BR
		$lang = get_bloginfo("language");

		if ($lang == 'pt-BR') {
			$header_logo = 'logo-bracell-branco-ci.svg';
			$header_logo2 = 'logo-bracell-ci.svg';
			$busca_placeholder = 'Digite aqui para buscar e dê enter...';
			$action_form_busca = get_home_url();
		} else {
			$header_logo = 'logo-bracell-branco-ci-eng.svg';
			$header_logo2 = 'logo-bracell-ci-eng.svg';
			$busca_placeholder = 'Type here to search and press enter...';
			$action_form_busca = 'https://centraldeindicadores2023.bracell.com/en/';
		}
		?>

		<header id="header">

			<div id="header-wrapper" class="header-scroll">
				<div class="container-fluid">
					<div id="logo">
						<a href="<?php echo get_home_url(); ?>" class="branco">
							<img src="<?php echo get_template_directory_uri() ?>/images/<?php echo $header_logo; ?>" alt="Logo - <?php echo get_bloginfo('name'); ?>" title="<?php echo get_bloginfo('name'); ?>" width="143" height="98" class="logo-img" />
						</a>
						<a href="<?php echo get_home_url(); ?>" class="colorido">
							<img src="<?php echo get_template_directory_uri() ?>/images//<?php echo $header_logo2; ?>" alt="Logo - <?php echo get_bloginfo('name'); ?>" title="<?php echo get_bloginfo('name'); ?>" width="143" height="98" class="logo-img" />
						</a>
					</div>
					<!-- end #logo -->

					<div id="menu-superior-wrapper">
						<!-- <div class="container"> -->
						<nav id="menu-superior" class="hidden-lg">
							<?php
							$args = array('menu' => 'Menu Superior');
							wp_nav_menu($args) ?>
						</nav>
						<!-- end #menu-superior.hidden-lg -->

						<div class="seletor-de-idiomas">
							<ul><?php pll_the_languages(array('show_flags' => 0, 'show_names' => 0, 'display_names_as' => 'slug')); ?></ul>
						</div>


						<div id="busca-topo">
							<img src="<?php echo get_template_directory_uri() ?>/images/icones/search-branco.svg" alt="Busca" title="Buscar" id="abrirBusca" class="branco" />
							<img src="<?php echo get_template_directory_uri() ?>/images/icones/search-azul.svg" alt="Busca" title="Buscar" id="abrirBusca" class="colorido" />
						</div>
						<!-- end #busca-topo -->

						<!-- </div> -->
					</div>
					<!-- end #menu-superior-wrapper -->


					<!-- BEGIN MENU MOBILE -->
					<div class="visible-lg">
						<nav id="menu-mobile">
							<span class="span1"></span>
							<span class="span2"></span>
							<span class="span3"></span>
						</nav>

						<div id="menu-mobile-wrapper">
							<?php wp_nav_menu(array('menu' => 'Menu Superior')); ?>

							<div class="seletor-de-idiomas mobile d-none">
								<ul><?php pll_the_languages(array('show_flags' => 0, 'show_names' => 0, 'display_names_as' => 'slug')); ?></ul>
							</div>
						</div>

						<div class="cover-dark"></div>
					</div>
					<!-- end .visible-lg -->


				</div>
				<!-- end .container -->
			</div>
			<!-- end #header-wrapper -->


			<div id="search-full-wrapper">
				<span id="fecharBusca"></span>
				<form role="search" method="get" id="searchform" class="searchform" action="<?php echo $action_form_busca; ?>" autocomplete="off">
					<input type="text" name="s" id="s" class="form-control txtBusca" required="required" placeholder="<?php echo $busca_placeholder; ?>" value="" autocomplete="off" />
					<input type="submit" name="" value="" />
				</form>
			</div>
			<!-- end #search-full-wrapper -->


		</header>
		<!-- end #header -->