<?php /* Template Name: Blog Template */ ?>
<?php get_header(); ?>

	<?php
	// Exibe Page Title e Breadcrumbs
	if (! is_page('home') ) {
		get_template_part('inc/bloco', 'breadcrumbs');
	}
	?>

	<div class="content-wrapper blog-page">

		<div class="container">
			<div class="row">
				<div class="col-md-12">
					
					<section id="blog-wrapper">
										
						<!-- LOOP 2 -->
						<section class="posts-wrapper loop2">

							<div class="sub titulo">
								<h2>Últimas <strong>Atualizações</strong></h2>
							</div>
							
							<?php
							global $paged;
							$curpage = $paged ? $paged : 1;

							//$categoriasExcluidas = array (8);
							
							$args = array(
								'post_type' => 'post',
								//'category__in'   => wp_get_post_categories( $post->ID ),
								//'category_name' => 'categoria b',
								//'category__not_in' => $categoriasExcluidas,
								'posts_per_page' => 50,
								'paged' => $paged
							);
							
							$query = new WP_Query($args);
							?>

							<?php if($query ->have_posts()) : ?>
								
								<?php while($query ->have_posts()) : $query ->the_post(); ?>
								
									<?php
									$post_ID = get_the_ID();
									$post_title = get_the_title();
									$post_link = get_the_permalink();
									$post_date = get_the_date('d.m.Y');
									$post_desc = get_the_excerpt();
									if ( has_post_thumbnail() ) {
										$post_bg = get_the_post_thumbnail_url($post_ID, 'medium');
										//$post_bg = get_the_post_thumbnail_url();
									} else {
										$post_bg = get_template_directory_uri().'/images/dummy-post.png';
									}
									?>
										
									<article class="article-item oculto">

										<div class="post-featured">
											<a href="<?php echo $post_link; ?>">
												<img src="<?php echo $post_bg; ?>" alt="" title="" />
											</a>
										</div>										
									
										<div class="post-meta">
											<div class="row">
												<div class="col-12">
													<div class="data"><?php echo $post_date;?></div>
												</div>
												<div class="col-12">
													<div class="categoria">
													<?php
													$categories = get_the_category();
													if ( ! empty( $categories ) ) {
														echo esc_html( $categories[0]->name );
													}
													?>
													</div>
												</div>
											</div>
										</div>
										
										<div class="post-title">
											<a href="<?php echo $post_link;?>">
												<h4><?php echo $post_title;?></h4>
											</a>
										</div>
										
									</article>
									<!-- end .article-item -->
										
								<?php endwhile; ?>
								
								<?php
								wp_reset_postdata();
								?>

							<?php else: ?>
								Nenhum artigo encontrado.
							<?php endif; ?>
							
							<div class="cta">
								<a href="<?php echo get_home_url();?>/categoria/categoria-b/">Ver mais</a>
							</div>

						</section>
						<!-- end .posts-wrapper -->

					</section>
					<!-- end #blog-wrapper -->
					
					
				</div>
				<!-- end .col-md-12 -->
			</div>
			<!-- end .row -->
		</div>
		<!-- .container -->
		
	</div>
	<!-- .content-wrapper -->

	<script>
	/*************************************************************************
	Paginacao dos Posts do Blog (Archive Page - Loop2)
	*************************************************************************/
	const postsDoLoop2 = document.querySelectorAll('.posts-wrapper.loop2 .article-item');
	//console.log(postsDoLoop2);
	//console.log(`A quantitade total de posts é: ${postsDoLoop2.length}`);

	// Exibe os 8 primeiros
	postsDoLoop2.forEach((item, index) => {
		//console.log(item, index);
		if ( index <= 7 ) {
			item.classList.remove('oculto');
			item.classList.add('visivel');
		}
	});

	// Ao clicar na paginacao, exibe +4
	const btnPaginacao = document.querySelector('.loop2 .cta a');
	btnPaginacao.addEventListener('click', function(event){
		event.preventDefault();
		
		let qtdDePostOcultos = document.querySelectorAll('.loop2 .article-item.oculto');
		console.log(`A quantitade total de posts ocultados é: ${qtdDePostOcultos.length}`);
		if (qtdDePostOcultos.length > 0) {
			//console.log('Ainda tem mais posts, então exibir mais 4');
			for (let i = 0; i<=3; i++) {
				qtdDePostOcultos[i].classList.remove('oculto');
				qtdDePostOcultos[i].classList.add('visivel');
			}
		} else {
			//btnPaginacao.innerText = 'Fim da paginação';
			document.querySelector('.loop2 .cta').style.display = 'none';
		}

	})
</script>
	
<?php get_footer(); ?>