<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package Shape
 * @since Shape 1.0
 */
 ?>

<?php get_header();?>

	<div class="content-wrapper internas" id="pag-busca-wrapper">
	
		<?php
		// Exibe Page Title e Breadcrumbs
		//get_template_part('inc/bloco', 'breadcrumbs');
		?>
		
		<?php 
		// Definicao das variáveis de multi-idiomas de acordo com idioma selecionado
		if (get_locale() == 'en_US') {
			// en
			$res_msg_de_resultados = 'Results for the search: %s';
			$res_nr_resultados_encontrados = 'results found.';
			$res_sem_resultados = 'Ops! Não foram encontrados resultados para busca! :/';
			$res_paginacao = 'Navigation';
			$res_paginacao_anterior = 'Previous';
			$res_paginacao_proximo = 'Next';
		}  else { 
			// pt-br
			$res_msg_de_resultados = 'Resultados de busca para: %s ';
			$res_nr_resultados_encontrados = 'resultados encontrados.';
			$res_sem_resultados = 'Ops! Não foram encontrados resultados para essa busca! :/';
			$res_paginacao = 'Navegação';
			$res_paginacao_anterior = 'Anterior';
			$res_paginacao_proximo = 'Próximo';
			
		}
		?>
		
	
		<header class="page-title-wrapper search">
			<div class="page-title">
				<div class="container">
					<div class="col-md-12">
						<div class="sub">
							<h1><?php printf( __( $res_msg_de_resultados ), '<span class="termo-pesquisado">"' . get_search_query() . '"</span>' ); ?></h1>
						</div>
					</div>
				</div>
			</div>
		</header>
		
		<div class="container">
		
			<div class="col-md-12">

				<div class="busca-resultados">
				
				<?php if ( have_posts() ) : ?>
				
					<?php
					global $wp_query;
					echo '<div class="aviso">' . $wp_query->found_posts . ' ' . $res_nr_resultados_encontrados . '</div>';
					?>
					
					<div class="gap40 hidden-xs"></div>
					<div class="gap20 visible-xs"></div>

					
					<ul id="lista-resultados-busca">
					
					<?php /* Start the Loop */ ?>
					<?php while ( have_posts() ) : the_post(); ?>
					
					<?php
					//echo get_post_type();
					$posttype = get_post_type();
					?>
					
						<?php
						if ( $posttype == 'post' ) {
							echo '<h3>Posts</h3>';
						?>
						
							<li>
								<figure>
									<a href="<?php the_permalink();?>">
										<?php 
										if ( has_post_thumbnail() ) {
												the_post_thumbnail('thumbnail');
										} else {
											echo '<img src="'.get_template_directory_uri().'/images/insert-image-product.jpg" alt="" title="" />';
										}
										?>
									</a>
								</figure>
								<div class="post-info">
									<div class="titulo">
										<a href="<?php the_permalink();?>">
											<?php echo get_the_title();?>
										</a>
									</div>
									
									<div class="desc">
										<p><?php echo get_the_excerpt(2);?></p>
									</div>
								</div>
							</li>
						<?php
						} elseif ( $posttype == 'page' ) {
							//echo '<h3>Outros resultados</h3>';
						?>
							<li class="result-tipo-paginas">
								<div class="titulo">
									<a href="<?php the_permalink();?>">
										<?php echo get_the_title();?>
									</a>
								</div>
							</li>
						<?php
						} else {
						?>
							<li class="result-tipo-paginas">
								<div class="titulo">
									<a href="<?php the_permalink();?>">
										<?php echo get_the_title();?>
									</a>
								</div>
								<div class="desc">
									<p><?php the_excerpt();?></p>
								</div>
							</li>
						<?php
						}
						?>

					<?php endwhile; ?>
					
					</ul>
					
					<div id="pagination-wrapper">
						<!--<div class="item-nav prev"><?php //next_posts_link( 'Voltar' ); ?></div>
						<div class="item-nav next"><?php //previous_posts_link( 'Avançar' ); ?></div>-->
						
						<?php
						$pagination = get_the_posts_pagination( array(
							'mid_size' => 2,
							'prev_text' => __( $res_paginacao_anterior, 'textdomain' ),
							'next_text' => __( $res_paginacao_proximo, 'textdomain' ),
							'screen_reader_text' => __( $res_paginacao )
						) );
						
						echo $pagination;
						?>
						
					</div>
					<!-- end #pagination-wrapper -->
					

				<?php else : ?>

					<div class="no-results">
						<div class="aviso"><h3><?php echo $res_sem_resultados; ?><br/></h3></div>
						<!--<span>Que tal tentar outro termo?</span></h2>-->
						
						<?php //get_search_form();?>
						
						<script>
						/*$(document).ready(function(){
							$('#searchform input[type="submit"]').val('Buscar');
						})*/
						</script>
						
					</div>

				<?php endif; ?>
					
				</div>
				<!-- end .busca-resultados -->
	
			
			</div>
			<!-- end .col-md-12 -->
			
		</div>
		<!-- .container -->
		
	</div>
	<!-- .content-wrapper -->
	
	<div class="gap40"></div>

<?php get_footer(); ?>