  window.onload = () => {
    //Setando uma variável global para a soma dos valores.
    window.somaValores = 0.0;

    //Guardando o input de soma total em uma variável global para não precisar acessa-lo toda vez.
    window.totalInvestimentosInput = document.querySelector(
      ".valores .form-group:last-child input"
    );

    //Guardando os inputs das somas em uma variável global para não precisar acessa-lo toda vez.
    window.investimentos = document.querySelectorAll(
      ".valores .form-group:nth-child(-n + 5) input"
    );

    //Aplicando a mascara aos valores.
    $(".valores input").mask("000.000.000.000.000,00", { reverse: true });

    //Capturando o evento de mudança dos campos de dinheiro.
    //Selecionando todos os inputs menos o último.
    investimentos.forEach((input) => {
      input.addEventListener("change", somarValores);
      input.maxLength = 22;
    });

    function somarValores() {
      somaValores = 0.0;

      investimentos.forEach((input) => {
        const valor = input.value.length > 0 ? input.value : "0";

        //Trocando os pontos e vírgulas do dinheiro em inglês para os correspondentes em pt-br.
        somaValores += parseFloat(
          valor.replaceAll(".", "").replaceAll(",", ".")
        );
      });
      totalInvestimentosInput.value = parseFloat(somaValores).toLocaleString(
        "pt-BR",
        { minimumFractionDigits: 2 }
      );
    }

    /*------------------------------------------------------------------*/
    //Garantindo que toda a info necessária foi preenchida.
    //document.querySelector("form").addEventListener("submit", () => {

    const wpcf7Elm = document.querySelector(".wpcf7");
    wpcf7Elm.addEventListener(
      "wpcf7mailsent",
      function (event) {
        //Se o valor do total estiver corretamente setado, pode mandar.
        if (!isNaN(parseFloat(totalInvestimentosInput.value))) {
          //Formando objeto com informações necessárias.

          const info = {
			total: totalInvestimentosInput.value,
			opcoes: document.querySelector("input[type='checkbox']:checked").value
		  };

          location =
            "https://agtdev2.com.br/projetos/financiamento/calculadora-resultado?" +
            new URLSearchParams(info).toString();

        }
      },
      false
    );
    
  };