window.onload = () => {
	function getQueryVariable(variable) {
		const query = window.location.search.substring(1);
		const vars = query.split("&");
		for (let i = 0; i < vars.length; i++) {
			const pair = vars[i].split("=");
			if (pair[0] === variable) {
				return pair[1];
			}
		}
		return false;
	}

	const totalInvestimentos = (getQueryVariable("total")).replaceAll(".", "").replaceAll(",", ".");
	const total = parseFloat(totalInvestimentos)
	const opcao = decodeURIComponent(getQueryVariable("opcoes"));
	switch(opcao){
		case 'Inédita+no+Brasil':
			changeContent(total, "5.78% a.a","48 meses", "192 meses");
		break;
		case 'Aumentará+a+participação+de+mercado+da+empresa':
			changeContent(total * 0.9,"5.78% a.a","36 meses", "144 meses");
		break;
		case 'Os+impactos+da+inovação+são+apenas+a+nível+interno,+não+impactando+o+posicionamento+da+empresa+no+mercado':
			changeContent(total * 0.8,"5.78% a.a","24 meses", "120 meses");
		break;
	}

	function changeContent(value,interest,time_to_use,time_mortgage){
		document.querySelector(".total strong").textContent =
		"R$ " + parseFloat(value).toLocaleString('pt-BR', {minimumFractionDigits: 2});

		document.querySelector(".info-total").textContent = "Principais condições: Juros a partir de "+ interest +", prazo de carência até "+ time_to_use+" e prazo total de financiamento até " + time_mortgage;
	}
};