<?php get_header(); ?>

<?php
if (have_posts()) :
?>

	<?php
	// Pega a URL atual
	$url = 'http://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];

	// Verifica se tem /pilar na URL
	// se tiver, não vamos exibir algumas coisas
	if (strpos($url, '/pilar/') !== false) {
		$tipoDoTemplateDaPagina = 'basico';
	} else {
		$tipoDoTemplateDaPagina = 'completo';
	}


	// Imagem de fundo do page title
	if (get_field('page_title_img', $term)) {
		$pageTitleBg = get_field('page_title_img', $term);
	} else { // padrao
		$pageTitleBg = get_template_directory_uri() . '/images/bg/header-padrao.png';
	}

	// Icone
	if (get_field('page_title_icon', $term)) {
		$pageTitleIcon = get_field('page_title_icon', $term);
	} else { // padrao
		$pageTitleIcon = get_template_directory_uri() . '/images/icones/headers/icone-acao-pelo-clima.svg';
	}

	// Titulo	
	if (get_field('page_title_tit', $term)) {
		$pageTitle = get_field('page_title_tit', $term);
	} else { // padrao
		$pageTitle = get_the_archive_title();
	}

	$lang = get_bloginfo("language");
	if ($lang == 'pt-BR') {
		$temaMaterialLabel = 'Tema material';
	} else {
		$temaMaterialLabel = 'Material topic';
	}

	// Pega o Tipo da Taxonomia da pagina
	$term = get_queried_object();
	$taxonomy = $term->taxonomy;
	switch ($taxonomy) {
		case 'tema-material':
			$pequenoTitulo = $temaMaterialLabel;
			break;
		case 'gri':
			$pequenoTitulo = 'GRI';
			break;
		case 'sasb':
			$pequenoTitulo = 'SASB';
			break;
		case 'ungc':
			$pequenoTitulo = 'UNGC';
			break;
		default:
			$pequenoTitulo = '';
			break;
	}

	// Descricao
	if (get_field('page_title_desc', $term)) {
		$pageTitleDesc = get_field('page_title_desc', $term);
	} else { // padrao
		$pageTitleDesc = '';
	}
	?>

	<div class="page-title-wrapper indicadores" style="background-image:url(<?php echo $pageTitleBg; ?>);">
		<div class="page-title">
			<!-- <div class="icone">
				<img src="<?php echo $pageTitleIcon; ?>" alt="Icone" title="Icone" />
			</div> -->
			<div class="conteudo">
				<h1 class="p-title">
					<span class="tipo-de-pag"><?php echo $pequenoTitulo; ?></span>
					<?php echo $pageTitle; ?>
				</h1>
				<div class="p-desc"><?php echo $pageTitleDesc; ?></div>
			</div>
		</div>
	</div>
	<!-- end .page-title-wrapper -->

	<div class="breadcrumbs">
		<div class="container">
			<div class="row">
				<div class="col-xs-12">
					<span>Home</span>
					<span><?php echo $pageTitle; ?></span>
					<!--<span><?php echo get_the_title(); ?></span>-->
				</div>
			</div>
		</div>
	</div>
	<!-- end .breadcrumbs -->


	<?php
	// Exibe o template de acordo com tipo da pagina
	if ($tipoDoTemplateDaPagina == 'basico') {
		get_template_part('inc/archive-basico');
	} else {
		get_template_part('inc/archive-completo');
	}
	?>



	<?php
	//wp_reset_postdata();
	?>

<?php
endif;
?>

<?php get_footer(); ?>