<?php /* Template Name: Home Template */ ?>
<?php get_header();?>

	<?php
	if (have_posts()) :
		while (have_posts()):
			the_post();
	?>		
		
		<div class="content-wrapper">

			<div class="container">

			<?php						
				the_content();
			?>
			
			</div>
			<!-- .container -->
		</div>
		<!-- .content-wrapper -->
			
	<?php
		endwhile;
	endif;
	?>

<script type="module">
  import { CountUp } from 'https://cdn.jsdelivr.net/npm/countup.js@latest/dist/countUp.min.js';

  const options = {
    threshold: 0.5, // Trigger when at least 50% of the element is visible
  };

  const observer = new IntersectionObserver((entries, obs) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        const element = entry.target;
        const target = parseFloat(element.textContent.replace(/[^\d.-]/g, ''));
        element.textContent = '0'; // Optional: reset before animation

        const counter = new CountUp(element, target, { duration: 2 });
        if (!counter.error) counter.start();

        obs.unobserve(element); // Run only once
      }
    });
  }, options);

  document.querySelectorAll('.number .valor').forEach(element => {
    observer.observe(element);
  });
</script>

<?php get_footer(); ?>