<?php
/* Template for single pages */
?>

<?php get_header();?>

<?php
// Exibe Page Title e Breadcrumbs
if (! is_page('home') ) {
	get_template_part('inc/bloco', 'breadcrumbs');
}
?>

<div class="content-wrapper single-blog">
	
	<!--<div id="hero-blog">
		<h1>Blog</h1>
	</div>-->
	<!-- end #hero-blog -->

	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<article class="article-item" id="<?php echo get_the_id();?>">

				<?php
				if (have_posts()) :
					while (have_posts()):
						the_post();
						global $post;
						?>
						
						<header class="post-header">
							<h1><?php echo get_the_title();?></h1>
						</header>

						<!--<div class="post__feature-img">
							<img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="Imagem - <?php echo get_the_title();?>" title="<?php echo get_the_title();?>" />
						</div>-->
						<!-- end .post__feature-img -->

						<div class="post__meta">
							<div class="row">
								<div class="col-md-6">
									<div class="column col-esq">
										<div class="author">Por 
											<?php
											$author_id = $post->post_author; 
											echo get_the_author_meta( 'first_name', $author_id );
											?>
										</div>
										<div class="date">
											<?php echo get_the_date("d/m/y");?> <?php echo get_the_date("H");?>h<?php echo get_the_date("i");?>
										</div>
									</div>
								</div>

								<div class="col-md-6 col-right">
									<div class="column">
										<div class="share-icons">
											<?php
											$urlDaPaginaAtual = "https://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
											//echo $urlDaPaginaAtual;
											?>
											<div class="cta">
												<a href="<?php echo $urlDaPaginaAtual; ?>" id="sharePostUrl">Compartilhar</a>
											</div>
											<a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo urlencode($urlDaPaginaAtual);?>" target="_blank" class="item-share linkedin" title="Compartilhe via Linkedin">
												<i class="fa fa-linkedin" aria-hidden="true"></i>
											</a>
										</div>
									</div>
								</div>
								
							</div>
						</div>
						<!-- end .post__meta -->

						<div class="post__content">
							<?php the_content(); ?>
						</div>
						<!-- end .post__content -->

						<?php 
						/*
						<div class="post__tags">
							<strong>TAGS</strong>
							<?php
							$tags = get_the_tags(get_the_ID());
							if ( $tags ) :
								foreach ( $tags as $tag ) : ?>
									<!--<a href="<?php echo get_home_url() .'/tag/'. $tag->slug; ?>" title="<?php echo esc_attr( $tag->name ); ?>"><?php echo esc_html( $tag->name ); ?></a>-->
									<a href="#"><?php echo esc_html( $tag->name ); ?></a>
								<?php endforeach; ?>
							<?php endif; ?>
						</div>
						*/
						?>

						<?php
						endwhile;
					endif;
					?>

				</article>
				<!-- end article -->
			</div>
			<!-- end .col-md-12 -->	
		</div>
		<!-- end .row -->
	</div>
	<!-- .container -->

	<section id="artigos-relacionados">
		<?php
		// Insere Bloco de Listagem de Artigos Relacionados
		get_template_part('inc/bloco', 'posts-relacionados');
		?>
	</section>
	<!-- end section#artigos-relacionados -->

</div>
<!-- .content-wrapper -->

<?php get_footer(); ?>