<nav id="menu-lateral" style="display: none;">
    <?php
    $args = array(
        'post_type' => 'indicador',
        'tax_query' => array(
            array(
            'taxonomy' => 'pilar',
            'field' => 'slug',
            'terms' => 'acao-pelo-clima',
            ),
        )
    );

    $the_query = new WP_Query( $args );

    if ( $the_query->have_posts() ) {
        echo '<ul>';
        echo '<li class="bracell2030"><a href="#">Metas Bracell 2030</a></li>';
        while ( $the_query->have_posts() ) {
            $the_query->the_post();
            echo '<li><a href="'.get_the_permalink().'"><strong>' . esc_html(get_field('indicador_identificador')) . '</strong><div class="nome">' . esc_html(get_field('indicador_nome')) . '</div></a></li>';
        }
        echo '</ul>';
    } else {
        esc_html_e( 'Sorry, no posts matched your criteria.' );
    }
    wp_reset_postdata();
    ?>
</nav>


<!-- MENU DINAMICAMENTE PREENCHIDO DE ACORDO COM A CATEGORIA ATUAL -->

<?php
// Get the archive type name
$term = get_queried_object();

if ($term instanceof WP_Term) {
    $archive_slug = $term->taxonomy;
    //echo $archive_slug;
    $tipoDeArchive = $archive_slug;
} else {
    //echo "Not in a taxonomy archive.";
}

// Get the term slug
$term_slug = get_query_var( 'term' );
?>

<nav id="menu-lateral">
    <?php
    $args = array(
        'post_type' => 'indicador',
        'orderby' => 'title',
        'order' => 'ASC',
        'tax_query' => array(
            array(
            'taxonomy' => $archive_slug,
            'field' => 'slug',
            'terms' => $term_slug,
            ),
        )
    );

    $the_query = new WP_Query( $args );

    if ( $the_query->have_posts() ) {

        $lang = get_bloginfo("language");
        if ($lang == 'pt-BR') {
            $menu_titulo = 'Menu de navegação';
        } else {
            $menu_titulo = 'Navigation menu';
        }

        $counter = 1;
        echo '<ul>';
        // echo '<li class="bracell2030"><a href="#">Metas Bracell 2030</a></li>';
        echo '<li class="bracell2030"><a href="#">' . $menu_titulo . '</a></li>';
        while ( $the_query->have_posts() ) {
            $the_query->the_post();
            if ($counter == 1) {
                echo '<li class="active"><a href="'.get_the_permalink().'" data-post-id="'.$post->ID.'"><strong>' . esc_html(get_field('indicador_identificador')) . '</strong><div class="nome">' . esc_html(get_field('indicador_nome')) . '</div></a></li>';
            } else {
                echo '<li><a href="'.get_the_permalink().'" data-post-id="'.$post->ID.'"><strong>' . esc_html(get_field('indicador_identificador')) . '</strong><div class="nome">' . esc_html(get_field('indicador_nome')) . '</div></a></li>';
            }
            $counter++;
        }
        echo '</ul>';
    } else {
        esc_html_e( 'Sorry, no posts matched your criteria.' );
    }
    wp_reset_postdata();
    ?>
</nav>