<?php
/* Template for single indicators pages */
?>

<?php get_header();?>

<?php
// Exibe Page Title e Breadcrumbs
//if (! is_page('home') ) {
	//get_template_part('inc/bloco', 'breadcrumbs');
//}
?>

<?php
// Depois precisa pegar dinamicamente os valores
if (get_field('page_title_tit')) {
	$pageTitle = get_field('page_title_tit');
} else {
	$pageTitle = 'Ação pelo Clima';
}

if (get_field('page_title_desc')) {
	$pageTitleDesc = get_field('page_title_desc');
} else {
	$pageTitleDesc = 'Criando uma operação positiva para o clima na direção de uma economia de baixo carbono';
}

if (get_field('page_title_img')) {
	$pageTitleBg = get_field('page_title_img');
} else {
	$pageTitleBg = get_template_directory_uri() . '/images/bg/header-acao-pelo-clima.jpg';
}

if (get_field('page_title_icon')) {
	$pageTitleIcon = get_field('page_title_icon');
} else {
	$pageTitleIcon = get_template_directory_uri() . '/images/icones/headers/icone-acao-pelo-clima.svg';
}
?>

<div class="page-title-wrapper indicadores" style="background-image:url(<?php echo $pageTitleBg; ?>);">
	<div class="page-title">
		<div class="icone">
			<img src="<?php echo $pageTitleIcon; ?>" alt="Icone" title="" />
		</div>
		<div class="conteudo">
			<h1 class="p-title"><?php echo $pageTitle; ?></h1>
			<div class="p-desc"><?php echo $pageTitleDesc; ?></div>
		</div>
	</div>
</div>
<!-- end .page-title-wrapper -->

<div class="breadcrumbs">
	<div class="container">
		<div class="row">
			<div class="col-xs-12">
				<span class="home"><img src="<?php echo get_template_directory_uri();?>/images/icones/home.svg" alt="Home" title="Home" /></span>
				<span>Bracell 2030</span>
				<span><?php echo $pageTitle; ?></span>
			</div>
		</div>
	</div>
</div>
<!-- end .breadcrumbs -->

<div class="content-wrapper single-indicador single-pilar">

	<div class="container">
		<div class="row">
			<!-- <div class="col-12 col-sm-10 offset-sm-1"> -->
			<div class="col-12 col-sm-12">
				<article class="article-item" id="<?php echo get_the_id();?>">

				<?php
				if (have_posts()) :
					while (have_posts()):
						the_post();
						global $post;
						?>
						
						<header class="post-header">
							<h1><?php echo get_the_title();?></h1>
						</header>

						<div class="post__content">
							<?php the_content(); ?>
						</div>
						<!-- end .post__content -->

						<?php
						endwhile;
					endif;
					?>

				</article>
				<!-- end article -->

			</div>
			<!-- end .col-sm-10 -->	
		</div>
		<!-- end .row -->	

	</div>
	<!-- .custom-container -->

</div>
<!-- .content-wrapper -->

<?php get_footer(); ?>