 <div class="titulo-ungc">
    <?php
    $terms = get_the_terms( $post->ID , 'ungc' );

    if ( $terms ) {
        echo 'UNGC';
    }
    ?>
</div>

<div class="numeros">
    <?php
    if ($terms) {
        foreach ( $terms as $term ) {

            switch ($term->slug) {
                case '1':
                    $textoDescricao = 'As empresas devem apoiar e respeitar a proteção de Direitos Humanos reconhecidos internacionalmente.';
                    $textoDescricaoEng = 'Businesses should support and respect the protection of internationally proclaimed human rights.';
                break;
                case '2':
                    $textoDescricao = 'Assegurar-se de sua não participação em violações destes direitos.';
                    $textoDescricaoEng = 'Make sure that they are not complicit in human rights abuses.';
                break;
                case '3':
                    $textoDescricao = 'As empresas devem apoiar a liberdade de associação e o reconhecimento efetivo do direito à negociação coletiva.';
                    $textoDescricaoEng = 'Businesses should uphold the freedom of association and the effective recognition of the right to collective bargaining.';
                break;
                case '4':
                    $textoDescricao = 'A eliminação de todas as formas de trabalho forçado ou compulsório.';
                    $textoDescricaoEng = 'The elimination of all forms of forced and compulsory labor.';
                break;
                case '5':
                    $textoDescricao = 'A abolição efetiva do trabalho infantil.';
                    $textoDescricaoEng = 'The effective abolition of child labor.';
                break;
                case '6':
                    $textoDescricao = ' Eliminar a discriminação no emprego.';
                    $textoDescricaoEng = 'The elimination of discrimination in respect of employment and occupation.';

                break;
                case '7':
                    $textoDescricao = 'As empresas devem apoiar uma abordagem preventiva aos desafios ambientais.';
                    $textoDescricaoEng = 'Businesses should support a precautionary approach to environmental challenges.';
                break;
                case '8':
                    $textoDescricao = 'Desenvolver iniciativas para promover maior responsabilidade ambiental.';
                    $textoDescricaoEng = 'Undertake initiatives to promote greater environmental responsibility.';
                break;
                case '9':
                    $textoDescricao = 'Incentivar o desenvolvimento e a difusão de tecnologias ambientalmente amigáveis.';
                    $textoDescricaoEng = 'Businesses should encourage the development and diffusion of environmentally friendly technologies.';
                break;
                case '10':
                    $textoDescricao = 'As empresas devem combater a corrupção em todas as suas formas, inclusive extorsão e propina.';
                    $textoDescricaoEng = 'Businesses should work against corruption in all its forms, including extortion and bribery.';
                break;
                default:
                    $textoDescricao = '...';
                    $textoDescricaoEng = '...';
                break;
            }

            $lang = get_bloginfo("language");
            if ($lang == 'pt-BR') {
                $textoDescricaoUng = $textoDescricao;
                $labelPrincipio = 'PRINCÍPIO';
            } else {
                $textoDescricaoUng = $textoDescricaoEng;
                $labelPrincipio = 'PRINCIPLE';
            }
        

            $textoDeSaida = '<div class="numero">'.$term->slug;
            $textoDeSaida .= '<div class="hidden-content">';
            $textoDeSaida .= '<strong>'. $labelPrincipio . ' ' . $term->slug . '</strong>';
            $textoDeSaida .= $textoDescricaoUng;
            $textoDeSaida .= '</div>';
            $textoDeSaida .= '</div>';

            echo $textoDeSaida;

        }
        
    }
    ?>
</div>