<?php
/* Template for single indicators pages */
?>

<?php get_header();?>

<?php
// Imagem do Page Title
$pageTitleBg = 'images/bg/header-padrao.png';

// Titulo
if ( ! get_field('indicador_custom_title') ) {
	$pageTitle = get_the_title();
} else {
	$pageTitle = get_field('indicador_custom_title');
}

// Tipo de Pagina
$urlDaPagina = $_SERVER['REQUEST_URI'];
if (strpos($urlDaPagina, 'rr-pp') !== false) {
	$tipoDaPag = 'SASB';
} else {
	$tipoDaPag = 'GRI';
}
?>

<div class="page-title-wrapper indicadores" style="background-image:url(<?php echo get_template_directory_uri() .'/'. $pageTitleBg; ?>);">
	<div class="page-title">
		<div class="conteudo">
			<h1 class="p-title d-none">
				<span class="tipo-de-pag"><?php echo $tipoDaPag; ?></span>
				<?php echo $pageTitle; ?>
			</h1>
		</div>
	</div>
</div>
<!-- end .page-title-wrapper -->

<div class="breadcrumbs">
	<div class="container">
		<div class="row">
			<div class="col-xs-12">
				<span>Home</span>
				<span><?php echo $pageTitle; ?></span>
			</div>
		</div>
	</div>
</div>
<!-- end .breadcrumbs -->

<div class="content-wrapper single-indicador">

	<div class="container">

		<div class="post__meta">
			<div class="row">
				<div class="col-md-4">
					<div class="column col-esq">
						<?php get_template_part('inc/bloco', 'ungc'); ?>
					</div>
				</div>

				<div class="col-md-8">
					<div class="column col-dir">
						<?php get_template_part('inc/bloco', 'ods'); ?>
					</div>
				</div>
				
			</div>
		</div>
		<!-- end .post__meta -->
		
	</div>
	<!-- end .container -->

	<div class="container container2">
		<div class="row">
			<div class="col-12 col-sm-10 offset-sm-1">
				<article class="article-item" id="<?php echo get_the_id();?>">

				<?php
				if (have_posts()) :
					while (have_posts()):
						the_post();
						global $post;
						?>
						
						<header class="post-header">
							<h1><?php echo get_the_title();?></h1>
						</header>

						<div class="post__content">
							<?php the_content(); ?>
						</div>
						<!-- end .post__content -->

						<?php
						endwhile;
					endif;
					?>

				</article>
				<!-- end article -->
			</div>
			<!-- end .col-sm-10 -->
		</div>
		<!-- end .row -->	
	</div>
	<!-- end .container -->

</div>
<!-- .content-wrapper -->

<?php get_footer(); ?>