//jQuery(document).ready(function($){
jQuery(document).ready(function () {
    /*************************************************************************
	Light Scrolling
	*************************************************************************/
    jQuery(
        'a[href^="#"]:not([href="#"]):not([href^="#accordeon"]):not([href^="#aba"]):not([href^="#faq"])'
    ).click(function () {
        jQuery('html, body').animate(
            {
                scrollTop: jQuery(jQuery.attr(this, 'href')).offset().top,
            },
            1000
        )
        return false
    })

    /*************************************************************************
	Menu Mobile
	*************************************************************************/
    let menuMobile = document.querySelector('#menu-mobile')
    const menuMobileWrapper = document.querySelector('#menu-mobile-wrapper')
    const coverDark = document.querySelector('.cover-dark')
    const menuMobileItens = document.querySelectorAll(
        '#menu-mobile-wrapper li a'
    )
    const body = document.querySelector('body')
    menuMobile.addEventListener('click', () => {
        menuMobile.classList.toggle('close')
        menuMobileWrapper.classList.toggle('open')
        menuMobileWrapper.classList.toggle('d-block')
        coverDark.classList.toggle('d-block')
        body.classList.toggle('travarBody')
    })

    coverDark.addEventListener('click', () => {
        menuMobile.classList.toggle('close')
        menuMobileWrapper.classList.toggle('open')
        menuMobileWrapper.classList.toggle('d-block')
        coverDark.classList.toggle('d-block')
        body.classList.toggle('travarBody')
    })

    /**********************************************
	Busca Topo (Search)
	**********************************************/
    $('#abrirBusca, #abrirBusca.colorido').on('click', function () {
        $('body').toggleClass('bloqueada')
        //$('#search-full-wrapper').toggleClass('d-none');
        $('#search-full-wrapper').addClass('d-flex')
        $('#search-full-wrapper').removeClass('d-none')
        $('#search-full-wrapper .txtBusca').focus()
    })

    $('#fecharBusca').on('click', function () {
        $('body').toggleClass('bloqueada')
        $('#search-full-wrapper').addClass('d-none')
        $('#search-full-wrapper').removeClass('d-flex')
    })

    document.body.addEventListener('keydown', function (event) {
        if (
            document.body.classList.contains('bloqueada') &&
            event.keyCode === 27
        ) {
            // Executa a função desejada
            $('body').toggleClass('bloqueada')
            $('#search-full-wrapper').addClass('d-none')
            $('#search-full-wrapper').removeClass('d-flex')
            console.log('click')
        }
    })

    /**********************************************
	Menu Fixo ao Rolar Pagina
	**********************************************/

    const checkWindowSize = () => {
        console.log(window.innerWidth)
        if (window.innerWidth > 800) {
            //console.log('eh maior que 800px de largura');

            //var previousScrollPosition = window.pageYOffset;
            var previousScrollPosition = window.scrollY

            window.addEventListener('scroll', function () {
                // var currentScrollPosition = window.pageYOffset;
                var currentScrollPosition = window.scrollY

                if (currentScrollPosition > previousScrollPosition) {
                    document
                        .querySelector('#header-wrapper')
                        .classList.add('hide-header')
                } else {
                    document
                        .querySelector('#header-wrapper')
                        .classList.remove('hide-header')
                }

                if (currentScrollPosition < 80) {
                    document
                        .querySelector('#header-wrapper')
                        .classList.add('header-scroll')
                } else {
                    document
                        .querySelector('#header-wrapper')
                        .classList.remove('header-scroll')
                }

                previousScrollPosition = currentScrollPosition
            })
        }
    }

    //Run the check when the page loads and whenever the window is resized
    ;['load', 'resize'].forEach((event) =>
        window.addEventListener(event, checkWindowSize)
    )

    /**********************************************
	Form Masks
	**********************************************/
    $('input.txtTel').mask('(99) 9999-9999')
    $('input.txtCel').mask('(99) 99999-9999')
    $('input.txtCepp').mask('99999-999')
    $('input.txtCpf').mask('999.999.999-99')
    $('input.txtCnpj').mask('99.999.999/9999-99')
    $('input.money').mask('#.##0,00', { reverse: true })

    // Telefone ou Celular 8 ou 9 digitos
    var SPMaskBehavior = function (val) {
            return val.replace(/\D/g, '').length === 11
                ? '(00) 00000-0000'
                : '(00) 0000-00009'
        },
        spOptions = {
            onKeyPress: function (val, e, field, options) {
                field.mask(SPMaskBehavior.apply({}, arguments), options)
            },
        }

    $('input.txtCelTel').mask(SPMaskBehavior, spOptions)

    /**********************************************
	Menu Lateral - Toggle Class
	**********************************************/
    $('#menu-lateral li').click(function () {
        $('#menu-lateral li').each(function () {
            if ($(this).hasClass('active')) {
                $(this).removeClass('active')
            }
        })
        $(this).addClass('active')
    })

    /**********************************************
	Menu Lateral Indicadores - Mobile
	**********************************************/
    $('#acionador-menu-lateral').click(function (e) {
        e.preventDefault()

        // Ao clicar no menu que ja tem a classe "active", fecha o menu
        if ($(this).hasClass('active')) {
            $('.col-left')
                .css({
                    display: 'hidden', // Make the div visible
                    left: '-100%', // Ensure it's off-screen initially
                })
                .animate(
                    {
                        left: '0%', // Animate to the final position
                        width: '0%', // Animate to the final width
                    },
                    300
                ) // Adjust the duration as needed (1000ms = 1s)

            $('.cover').css('display', 'none')
            $('body').removeClass('bloqueada')
            $(this).removeClass('active')

            // Ao clicar exibe menu
        } else {
            $('.col-left')
                .css({
                    display: 'block',
                    left: '-100%',
                })
                .animate(
                    {
                        left: '0%',
                        width: '80%',
                    },
                    300
                )

            $('.cover').css('display', 'block')
            $('body').addClass('bloqueada')
            $(this).addClass('active')
        }

        // Ao clicar no cover, fecha...
        $('.cover').click(function (e) {
            $('.col-left')
                .css({
                    display: 'hidden',
                    left: '-100%',
                })
                .animate(
                    {
                        left: '0%',
                        width: '0%',
                    },
                    1000
                )

            $('.cover').css('display', 'none')
            $('body').removeClass('bloqueada')
            $('#acionador-menu-lateral').removeClass('active')
        })

        // Ao clica em algum item do menu, fecha e scrolla top
        $('.col-left li').click(function (e) {
            $('.col-left')
                .css({
                    display: 'hidden',
                    left: '-100%',
                })
                .animate(
                    {
                        left: '0%',
                        width: '0%',
                    },
                    1000
                )

            $('.cover').css('display', 'none')
            $('body').removeClass('bloqueada')
            $('#acionador-menu-lateral').removeClass('active')

            $('html, body').animate(
                {
                    scrollTop: $('.col-right').offset().top,
                },
                300
            )
            return false
        })
    })

    /**********************************************
	Selecionar todas tabelas e colocar uma div .table-responsive ao redor
	**********************************************/
    $('table').each(function () {
        $(this).wrap('<div class="table-responsive"></div>')
    })
    //$('table').wrap('<div class="table-responsive"></div>');
})
