<div id="ultimos-relatorios-wrapper">

	<?php 
	// Variaveis de acordo com Idioma
	if (get_locale() == 'en_US') {
		$titulo = 'Last Reports';
		$semResultado = 'No reports found!';
	} else {
		$titulo = 'Últimos Relatórios';
		$semResultado = 'Nenhum relatório encontrado!';
	}
	?>

	<div class="sub title">
		<h3><?php echo $titulo; ?></h3>
	</div>

	<?php
	global $post;
	$idDaPag = get_the_ID();
	if( $idDaPag == 155 ) {
		$numeroDePostsPorPagina = 4;
	} else {
		$numeroDePostsPorPagina = 8;
	}

	$args = array(
		'post_type' => 'report',
		'posts_per_page' => $numeroDePostsPorPagina
	);

	$query = new WP_Query( $args );

	if ( $query->have_posts() ) {

		echo '<table class="table reports-table">';

		while ( $query->have_posts() ) {
			$query->the_post(); 
			?>

			<?php
			//$report_ID = get_the_ID();
			$report_title = get_the_title();
			//$report_permalink = get_the_permalink();
			$report_date = get_the_date('d/m/Y');
			//$report_desc = get_the_excerpt();
			if ( has_post_thumbnail() ) {
				$post_bg = get_the_post_thumbnail_url($post_ID, 'medium_large');
			} else {
				$post_bg = get_template_directory_uri().'/img/dummy-post.png';
			}

			if ( get_field('report_file') ) {
				$report_link = get_field('report_file');
			} else {
				$report_link = get_field('report_file_link');
			}
			?>

			<tr class="relatorio-item">
				<td class="">
					<span class="report-date"><?php echo $report_date;?> - </span>
					<span class="report-name">
						<a href="<?php echo $report_link;?>" target="_blank">
							<?php echo $report_title;?>
						</a>
					</span>
				</td>
			</tr>
				
		<?php
		}
		echo '</table>';
	} else {
		echo $semResultado;
	}
	?>

</div>
<!-- end #ultimos-relatorios-wrapper -->