<?php

// Variaveis de acordo com Idioma
if (get_locale() == 'en_US') {
	$readMore = 'Read more';
	$nextPag = 'Next';
	$previousPag = 'Previous';
} else {
	$readMore = 'Leia mais';
	$nextPag = 'Próximo';
	$previousPag = 'Anterior';
}

$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;


$args = array(
	'post_type' => 'post',
	'posts_per_page' => 4,
	//'offset'         => 3
	'paged' => $paged
);

$query = new WP_Query( $args );

if ( $query->have_posts() ) {
	while ( $query->have_posts() ) {
		$query->the_post(); 
		?>

		<?php
		$post_ID = get_the_ID();
		$post_title = get_the_title();
		$post_link = get_the_permalink();
		$post_date = get_the_date('d.m.Y');
		$post_desc = get_the_excerpt();
		if ( has_post_thumbnail() ) {
			$post_bg = get_the_post_thumbnail_url($post_ID, 'medium_large');
		} else {
			//$post_bg = get_template_directory_uri().'/images/dummy-blog-usda.png';
			$post_bg = get_template_directory_uri().'/images/dummy-post.svg';
		}
		?>

		<article class="">

			<div class="row">
				<div class="col-sm-6 col-esq">
					<!-- <div class="post-featured" style="background-image: url(<?php echo $post_bg; ?>);"></div> -->
					<div class="post-featured">
						<a href="<?php echo get_the_permalink();?>">
							<img src="<?php echo $post_bg; ?>" alt="<?php echo $post_title; ?>" title="<?php echo $post_title; ?>" />
						</a>
					</div>
				</div>
				<!-- end .col-esq -->

				<div class="col-sm-6 col-dir">
					<!-- <div class="post-meta">
						<div class="categoria">
						<?php
						// $categories = get_the_category();
						// if ( ! empty( $categories ) ) {
						// 	echo esc_html( $categories[0]->name );
						// }
						?>
						</div>
					</div> -->

					<!-- <div class="post-date">
						<div class="data"><?php echo $post_date;?></div>
					</div> -->

					<div class="post-title">
						<!-- <a href="<?php echo $post_link;?>"> -->
							<h1><?php echo $post_title;?></h1>
						<!-- </a> -->
					</div>
					<div class="post-sub">
						<?php echo get_field('post_sub'); ?>
					</div>
					<div class="post-desc">
						<p><?php echo get_the_excerpt(); ?></p>
					</div>
					<div class="post-cta">
						<a href="<?php echo $post_link;?>"><?php echo $readMore;?></a>
					</div>
				</div>
				<!-- end .col-dir -->
			</div>
			<!-- end .row -->
		</article>
			

	<?php
	}


	// Pagination
	$pagination_args = array(
		'total' => $query->max_num_pages,
		'current' => $paged,
		'prev_text' => __( $previousPag, 'text-domain' ),
		'next_text' => __( $nextPag, 'text-domain' ),
	);
	
	echo '<div id="paginacao-wrapper">';
		echo paginate_links( $pagination_args );
	echo '</div>';

}
?>