<?php
/**
 * The template for displaying taxonomy archives.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Twenty
 * @since Twenty Twenty 1.0
 */

get_header();
?>

<div id="primary" class="content-area">
    <main id="main" class="site-main">

    <?php if ( have_posts() ) : ?>

        <header class="page-header">
            <?php
                the_archive_title( '<h1 class="page-title">', '</h1>' );
                the_archive_description( '<div class="archive-description">', '</div>' );
            ?>
        </header><!-- .page-header -->

        <?php
        // Start the Loop.
        while ( have_posts() ) :
            the_post();

            if (get_field('page_title_tit')) {
                $pageTitle = get_field('page_title_tit');
                echo 'tem tit custom';
            } else {
                $pageTitle = get_the_archive_title();
                echo 'n tem tit custom';
            }

            /*
             * Include the Post-Type-specific template for the content.
             * If you want to override this in a child theme, then include a file
             * called content-___.php (where ___ is the Post Type name) and that will be used instead.
             */
            get_template_part( 'template-parts/content/content', get_post_type() );

        endwhile;

        // Previous/next page navigation.
        //twenty_twenty_the_posts_navigation();

    else :
        // If no content, include the "No posts found" template.
        get_template_part( 'template-parts/content/content', 'none' );

    endif;
    ?>

    </main><!-- #main -->
</div><!-- #primary -->

<?php
get_footer();
