<?php
// Definicao de strings de acordo com idioma
//en-US
//pt-BR

$lang = get_bloginfo("language");

if ($lang == 'pt-BR') {
	$footer_text = 'Uma das líderes globais na produção de celulose solúvel especial, a Bracell baseia <br/>suas operações no cultivo sustentável de eucalipto e fábricas de última	 geração.';
} else {
	$footer_text = 'One of the global leaders in the production of special dissolving pulp, Bracell bases <br/>its operations on the sustainable cultivation of eucalyptus and state-of-the-art factories.';
}
?>

<footer id="footer">
	<div class="container">
		<div class="row">
			<div class="col-12 footer_logo">
				<a href="<?php echo get_home_url(); ?>" target="_self">
					<img width="190" height="43" src="<?php echo get_template_directory_uri(); ?>/images/logo-bracell-branco.svg" class="" alt="Logo Bracell" title="Bracell">
				</a>
			</div>
			<div class="col-12 footer_text">
				<p><?php echo $footer_text; ?></p>
			</div>
			<div class="col-12 footer_menu">
				<?php
				$args = array('menu' => 'Menu Footer');
				wp_nav_menu($args);
				?>
			</div>
			<div class="col-12 footer_social">
				<a href="mailto:faleconoscosp@bracell.com" target="_blank">
					<img width="" height="" src="<?php echo get_template_directory_uri(); ?>/images/icones/email.svg" class="" alt="E-mail" title="E-mail">
				</a>
				<a href="https://www.instagram.com/somosbracell/" target="_blank">
					<img width="" height="" src="<?php echo get_template_directory_uri(); ?>/images/icones/insta.svg" class="" alt="Instagram" title="Instagram">
				</a>
				<a href="https://www.facebook.com/SomosBracell/" target="_blank">
					<img width="" height="" src="<?php echo get_template_directory_uri(); ?>/images/icones/face.svg" class="" alt="Facebook" title="Facebook">
				</a>
				<a href="https://www.youtube.com/channel/UCNWL4AL-JDYiLF5IHhCZbjA" target="_blank">
					<img width="" height="" src="<?php echo get_template_directory_uri(); ?>/images/icones/youtube.svg" class="" alt="Youtube" title="Youtube">
				</a>
				<a href="https://www.linkedin.com/company/1295171" target="_blank">
					<img width="" height="" src="<?php echo get_template_directory_uri(); ?>/images/icones/linkedin.svg" class="" alt="Linkedin" title="Linkedin">
				</a>
			</div>
		</div>
	</div>
</footer>
<!-- end #footer -->

<div id="copyright">
	<div class="container">
		<div class="row">
			<div class="col-12">
				© 2024 Bracell.
			</div>
		</div>
	</div>
</div>
<!-- end #copyright -->

<?php
//get_template_part("inc/bloco", "cookies-footer"); 
?>

<script src="<?php echo get_template_directory_uri(); ?>/js/functions.js?v=1.09"></script>
<script src="https://use.fontawesome.com/c3a8c28aad.js"></script>

<?php wp_footer(); ?>

</div>
<!-- end .main-wrapper -->

</body>

</html>